/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class sTaskFreeSpace {
    public static final int fileSystem = 0;
    public static final int diskType = 1;
    public static final int diskSpace = 2;
    public static final int usedSpace = 3;
    public static final int freeSpace = 4;
    public static final int percntUse = 5;
    public static final int mountPoint = 6;
    private static String cmdPrefix = "/bin/df -T -B 1MB ";
    private static String cmdSuffix = " \\| grep -v Filesystem";
    private TaskFreeSpace m_freeTask;
    private TaskContainerFreeSpace m_conTask;

    public sTaskFreeSpace(TaskFreeSpace genTask) {
        this.m_freeTask = genTask;
    }

    public sTaskFreeSpace(TaskContainerFreeSpace genTask) {
        this.m_conTask = genTask;
    }

    public sTaskFreeSpace() {
    }

    public String getCommand(String location) {
        return cmdPrefix + location + cmdSuffix;
    }

    public String getData(String cmdoutput, int dataRequested) {
        int noSuchDev;
        String outputLine;
        String returnData;
        String unknown = new String("UNKNOWN");
        String zero = new String("0");
        int i = 0;
        switch (dataRequested) {
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                returnData = unknown;
                break;
            }
            default: {
                returnData = zero;
            }
        }
        cmdoutput = cmdoutput.replaceAll(Pattern.quote(VerificationUtil.LSEP), "");
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nLine(s): " + cmdoutput + "\ndataReqested: " + dataRequested + "\n"));
        }
        StringTokenizer st = new StringTokenizer(cmdoutput, "\n");
        try {
            outputLine = st.nextToken();
        }
        catch (NoSuchElementException nse) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: cannot get line tokens from: '" + cmdoutput + "'\nReturning: " + returnData + "\n"));
            }
            return returnData;
        }
        if (st.countTokens() >= 1) {
            if (dataRequested == 0) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nReturning: " + outputLine + "\n"));
                }
                return outputLine;
            }
            try {
                outputLine = st.nextToken();
            }
            catch (NoSuchElementException nse) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("NOSUCHELEMENTEXCEPTION: could not get second line \nReturning: " + returnData + "\n"));
                }
                return returnData;
            }
        }
        if ((noSuchDev = outputLine.indexOf("No such file or directory")) != -1) {
            return returnData;
        }
        try {
            StringTokenizer dl = new StringTokenizer(outputLine, " ");
            if (st.countTokens() > 1) {
                i = 1;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("dl token count: '" + dl.countTokens() + "' st token count: '" + st.countTokens() + "'" + "\nOutput line: '" + outputLine + "'"));
            }
            while (i <= dataRequested) {
                returnData = dl.nextToken();
                Trace.out((String)("returnData: '" + returnData + "' i: '" + i + "'"));
                ++i;
            }
            int strToken = returnData.indexOf("</CV_VAL>");
            if (strToken != -1) {
                String newReturnVal;
                returnData = newReturnVal = returnData.substring(0, strToken);
            }
        }
        catch (NoSuchElementException nse) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("NOSUCHELEMENTEXCEPTION: Returning: " + returnData + "\n"));
            }
            return returnData;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("\nReturning: " + returnData + "\n"));
        }
        return returnData;
    }
}

